/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.city.guild.IBuildingAuction;
import ch.sahits.game.openpatrician.model.city.guild.IShipAuction;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ModelFactory {
    @Autowired
    private ApplicationContext context;

    public IBuildingAuction createBuildingAuction(LocalDateTime auctionDate, int startingBid, IPlayer owner, IBuilding building) {
        return (IBuildingAuction)this.context.getBean("buildingAuction", new Object[]{auctionDate, startingBid, owner, building});
    }

    public IShipAuction createAnonymousShipAuction(LocalDateTime auctionDate, int startingBid, IShip ship) {
        return (IShipAuction)this.context.getBean("shipAuction", new Object[]{auctionDate, startingBid, ship});
    }

    public IShipAuction createShipAuction(LocalDateTime auctionDate, int startingBid, IPlayer owner, IShip ship) {
        return (IShipAuction)this.context.getBean("shipAuction", new Object[]{auctionDate, startingBid, owner, ship});
    }
}

