/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.impl.Contribution;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDateTime;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class Contributions {
    @Autowired
    private Date date;
    @MultimapType(key=IWare.class, value=Contribution.class)
    private Multimap<IWare, Contribution> contributions = ArrayListMultimap.create();

    public int getContribution(IWare ware) {
        int sum = 0;
        LocalDateTime lastWeek = this.date.getCurrentDate().minusDays(7L);
        Iterator iterator = this.contributions.get((Object)ware).iterator();
        while (iterator.hasNext()) {
            Contribution contrib = (Contribution)iterator.next();
            if (contrib.getTimestamp().isBefore(lastWeek)) {
                iterator.remove();
                continue;
            }
            sum += contrib.getAmount();
        }
        return sum;
    }

    public void contribute(IWare ware, int amount) {
        LocalDateTime now = this.date.getCurrentDate();
        LocalDateTime lastWeek = this.date.getCurrentDate().minusDays(7L);
        if (this.contributions.containsKey((Object)ware)) {
            Iterator iterator = this.contributions.get((Object)ware).iterator();
            while (iterator.hasNext()) {
                Contribution contrib = (Contribution)iterator.next();
                if (!contrib.getTimestamp().isBefore(lastWeek)) continue;
                iterator.remove();
            }
        }
        this.contributions.put((Object)ware, (Object)new Contribution(now, amount, ware));
    }
}

