/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.impl.Player;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import ch.sahits.game.openpatrician.model.player.AIPlayerContext;
import ch.sahits.game.openpatrician.model.player.BaseStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategyType;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireSailorsStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.player.IProductionConsumptionKnowledge;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.product.ITradeStep;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.service.RandomNameLoader;
import com.google.common.collect.LinkedHashMultimap;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="aiPlayer")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class AIPlayer
extends Player
implements IAIPlayer {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(AIPlayer.class);
    @MultimapType(key=INavigableVessel.class, value=ITradeStep.class)
    private LinkedHashMultimap<INavigableVessel, ITradeStep> tradeSteps = LinkedHashMultimap.create();
    @MapType(key=INavigableVessel.class, value=ITradeMissionData.class)
    private Map<INavigableVessel, ITradeMissionData> tradeMissions = new HashMap<INavigableVessel, ITradeMissionData>();
    @MapType(key=INavigableVessel.class, value=Boolean.class)
    private Map<INavigableVessel, Boolean> waitingStatus = new HashMap<INavigableVessel, Boolean>();
    @MapType(key=INavigableVessel.class, value=IAITradeStrategyType.class)
    private Map<INavigableVessel, IAITradeStrategyType> tradeStrategyType = new HashMap<INavigableVessel, IAITradeStrategyType>();
    private IAIShipRepairStrategyType shipRepairStrategyType;
    private IAIConstructionSelectionStrategyType constructionSelectionType;
    private IAICaptainHireStrategyType captainHireStrategyType;
    private IAITakeLoanStrategyType takeLoanStrategyType;
    private IAIEventDecisionStrategyType eventDecitionStrategyType;
    @Autowired
    private IProductionConsumptionKnowledge knowledge;
    private AIPlayerContext playerContext = new AIPlayerContext();
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public AIPlayer(ICity homeTown, LocalDateTime birthDate, ICompany company) {
        super(homeTown, AIPlayer.getPersonalData(homeTown, birthDate), ESocialRank.BARGAINER, company);
    }

    private static PersonalData getPersonalData(ICity homeTown, LocalDateTime birthDate) {
        return new PersonalData(AIPlayer.getRandomFirstName(), AIPlayer.getRandomLastName(), true, homeTown, birthDate);
    }

    private static String getRandomFirstName() {
        return firstNameLoader.getRandomName();
    }

    private static String getRandomLastName() {
        return lastNameLoader.getRandomName();
    }

    @Override
    public IProductionConsumptionKnowledge getProductionAndConsumptionKnowledge() {
        return this.knowledge;
    }

    @Override
    public ITradeStep getNextTradeStep(INavigableVessel vessel) {
        Set steps = this.tradeSteps.get((Object)vessel);
        ITradeStep first = (ITradeStep)steps.iterator().next();
        this.tradeSteps.remove((Object)vessel, (Object)first);
        return first;
    }

    @Override
    public boolean hasMoreTradeSteps(INavigableVessel vessel) {
        return this.tradeSteps.get((Object)vessel) != null && !this.tradeSteps.get((Object)vessel).isEmpty();
    }

    @Override
    public void addTradeStep(ITradeStep tradeStep, INavigableVessel vessel) {
        this.tradeSteps.put((Object)vessel, (Object)tradeStep);
    }

    @Override
    public void injectTradeStep(ITradeStep tradeStep, INavigableVessel vessel) {
        ArrayList existingSteps = new ArrayList(this.tradeSteps.get((Object)vessel));
        this.tradeSteps.removeAll((Object)vessel);
        this.tradeSteps.put((Object)vessel, (Object)tradeStep);
        for (ITradeStep existingStep : existingSteps) {
            this.tradeSteps.put((Object)vessel, (Object)existingStep);
        }
    }

    @Override
    public ITradeMissionData getTradeMission(INavigableVessel vessel) {
        return this.tradeMissions.get(vessel);
    }

    @Override
    public void setTradeMission(INavigableVessel vessel, ITradeMissionData tradeMission) {
        if (tradeMission != null) {
            this.tradeMissions.put(vessel, tradeMission);
        } else {
            this.tradeMissions.remove(vessel);
        }
    }

    @Override
    public boolean waitingForTradeStepToFinish(INavigableVessel vessel) {
        if (!this.isInitialized(vessel)) {
            this.waitingStatus.put(vessel, false);
        }
        return this.waitingStatus.get(vessel);
    }

    @Override
    public void updateTradeWaitingStatus(INavigableVessel vessel, boolean wait) {
        this.waitingStatus.put(vessel, wait);
    }

    @Override
    public boolean isInitialized(INavigableVessel vessel) {
        return this.waitingStatus.containsKey(vessel);
    }

    @Override
    public void setTradeStrategyType(INavigableVessel vessel, IAITradeStrategyType type) {
        LOGGER.debug("Set trade strategy {} for vessel {}", (Object)type, (Object)vessel.getName());
        this.tradeStrategyType.put(vessel, type);
        this.tradeSteps.removeAll((Object)vessel);
    }

    @Override
    public IAITradeStrategyType getTradeStrategyType(INavigableVessel vessel) {
        return this.tradeStrategyType.get(vessel);
    }

    @Override
    public IAIHireTradeManagerStrategyType getHireTradeManagerStrategyType() {
        for (BaseStrategyType<?> strategyType : this.playerContext.getGeneralStrategyTypes()) {
            if (!(strategyType instanceof IAIHireTradeManagerStrategyType)) continue;
            return (IAIHireTradeManagerStrategyType)strategyType;
        }
        return null;
    }

    @Override
    public IAIGuildJoinStrategyType getGuildJoinStrategyType() {
        for (BaseStrategyType<?> strategyType : this.playerContext.getGeneralStrategyTypes()) {
            if (!(strategyType instanceof IAIGuildJoinStrategyType)) continue;
            return (IAIGuildJoinStrategyType)strategyType;
        }
        return null;
    }

    @Override
    public IAIBuyWeaponStrategyType getWeaponBuyStrategyType() {
        for (BaseStrategyType<?> strategyType : this.playerContext.getGeneralStrategyTypes()) {
            if (!(strategyType instanceof IAIBuyWeaponStrategyType)) continue;
            return (IAIBuyWeaponStrategyType)strategyType;
        }
        return null;
    }

    @Override
    public IAIHireSailorsStrategyType getHireSailorStrategyType() {
        for (BaseStrategyType<?> strategyType : this.playerContext.getGeneralStrategyTypes()) {
            if (!(strategyType instanceof IAIHireSailorsStrategyType)) continue;
            return (IAIHireSailorsStrategyType)strategyType;
        }
        return null;
    }

    @Override
    public IAIShipUpgradeStrategyType getShipUpgradeStrategyType() {
        for (BaseStrategyType<?> strategyType : this.playerContext.getGeneralStrategyTypes()) {
            if (!(strategyType instanceof IAIShipUpgradeStrategyType)) continue;
            return (IAIShipUpgradeStrategyType)strategyType;
        }
        return null;
    }

    @Override
    public IAIShipRepairStrategyType getShipRepairStrategyType() {
        return this.shipRepairStrategyType;
    }

    public void setShipRepairStrategyType(IAIShipRepairStrategyType shipRepairStrategyType) {
        this.shipRepairStrategyType = shipRepairStrategyType;
    }

    public void setConstructionSelectionType(IAIConstructionSelectionStrategyType constructionSelectionType) {
        this.constructionSelectionType = constructionSelectionType;
    }

    @Override
    public IAIConstructionSelectionStrategyType getConstructionSelectionType() {
        return this.constructionSelectionType;
    }

    public void setCaptainHireStrategyType(IAICaptainHireStrategyType captainHireStrategyType) {
        this.captainHireStrategyType = captainHireStrategyType;
    }

    @Override
    public IAICaptainHireStrategyType getCaptainHireStrategyType() {
        return this.captainHireStrategyType;
    }

    @Override
    public IAITakeLoanStrategyType getTakeLoanStrategyType() {
        return this.takeLoanStrategyType;
    }

    public void setTakeLoanStrategyType(IAITakeLoanStrategyType takeLoanStrategyType) {
        this.takeLoanStrategyType = takeLoanStrategyType;
    }

    @Override
    public IAIEventDecisionStrategyType getEventDecitionStrategyType() {
        return this.eventDecitionStrategyType;
    }

    public void setEventDecitionStrategyType(IAIEventDecisionStrategyType eventDecitionStrategyType) {
        this.eventDecitionStrategyType = eventDecitionStrategyType;
    }

    @Override
    public AIPlayerContext getPlayerContext() {
        return this.playerContext;
    }
}

