/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Armory
implements IArmory {
    private static final double EXPERIENCE_GAIN = 0.005;
    @Autowired
    private IWeaponStorage weaponStorage;
    @Autowired
    private Date date;
    @Autowired
    private IMap map;
    private final ICity city;
    @MapType(key=IWeapon.class, value=Boolean.class)
    private HashMap<IWeapon, Boolean> priority = new HashMap();
    private double experience;
    private LocalDateTime occupied;

    public Armory(ICity city) {
        this.city = city;
    }

    @PostConstruct
    private void init() {
        for (EWeapon weapon : EWeapon.values()) {
            this.priority.put(weapon, false);
        }
        int mapWidth = (int)this.map.getDimension().getWidth();
        double eastFactor = this.city.getCoordinates().getX() / (double)mapWidth / 0.5;
        double startYearPart = Math.max((this.date.getStartYear() - 1430) / 100, 0);
        this.experience = Math.max(startYearPart - eastFactor, 0.0);
        Preconditions.checkArgument((this.experience >= 0.0 ? 1 : 0) != 0, (Object)"Experiance must be positive");
        this.occupied = this.date.getCurrentDate().minusDays(1L);
    }

    @Override
    public ReadOnlyIntegerProperty swordAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.SWORD);
    }

    @Override
    public ReadOnlyIntegerProperty bowAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.BOW);
    }

    @Override
    public ReadOnlyIntegerProperty crossbowAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.CROSSBOW);
    }

    @Override
    public ReadOnlyIntegerProperty musketAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.MUSKET);
    }

    @Override
    public ReadOnlyIntegerProperty cutlassAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.HAND_WEAPON);
    }

    @Override
    public ReadOnlyIntegerProperty trebuchetSmallAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.TREBUCHET_SMALL);
    }

    @Override
    public ReadOnlyIntegerProperty trebuchetBigAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.TREBUCHET_BIG);
    }

    @Override
    public ReadOnlyIntegerProperty ballistaSmallAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.BALLISTA_SMALL);
    }

    @Override
    public ReadOnlyIntegerProperty ballistaBigAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.BALLISTA_BIG);
    }

    @Override
    public ReadOnlyIntegerProperty bombardAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.BOMBARD);
    }

    @Override
    public ReadOnlyIntegerProperty canonAmountProperty() {
        return this.weaponStorage.getWeaponProperty(EWeapon.CANNON);
    }

    @Override
    public boolean isSwordPriority() {
        return this.priority.get(EWeapon.SWORD);
    }

    @Override
    public boolean isBowPriority() {
        return this.priority.get(EWeapon.BOW);
    }

    @Override
    public boolean isCrossbowPriority() {
        return this.priority.get(EWeapon.CROSSBOW);
    }

    @Override
    public boolean isMusketPriority() {
        return this.priority.get(EWeapon.MUSKET);
    }

    @Override
    public void toggleSwordPriority() {
        this.priority.put(EWeapon.SWORD, this.priority.get(EWeapon.SWORD) == false);
    }

    @Override
    public void toggleBowPriority() {
        this.priority.put(EWeapon.BOW, this.priority.get(EWeapon.BOW) == false);
    }

    @Override
    public void toggleCrossbowPriority() {
        this.priority.put(EWeapon.CROSSBOW, this.priority.get(EWeapon.CROSSBOW) == false);
    }

    @Override
    public void toggleMusketPriority() {
        this.priority.put(EWeapon.MUSKET, this.priority.get(EWeapon.MUSKET) == false);
    }

    @Override
    public void updateSwordAmount(int delta) {
        this.weaponStorage.update(EWeapon.SWORD, delta);
    }

    @Override
    public void updateBowAmount(int delta) {
        this.weaponStorage.update(EWeapon.BOW, delta);
    }

    @Override
    public void updateCrossbowAmount(int delta) {
        this.weaponStorage.update(EWeapon.CROSSBOW, delta);
    }

    @Override
    public void updateMusketAmount(int delta) {
        this.weaponStorage.update(EWeapon.MUSKET, delta);
    }

    @Override
    public void updateCutlassAmount(int delta) {
        this.weaponStorage.update(EWeapon.HAND_WEAPON, delta);
    }

    @Override
    public void updateTrebuchetSmallAmount(int delta) {
        this.weaponStorage.update(EWeapon.TREBUCHET_SMALL, delta);
    }

    @Override
    public void updateTrebuchetBigAmount(int delta) {
        this.weaponStorage.update(EWeapon.TREBUCHET_BIG, delta);
    }

    @Override
    public void updateBallistaSmallAmount(int delta) {
        this.weaponStorage.update(EWeapon.BALLISTA_SMALL, delta);
    }

    @Override
    public void updateBallistaBigAmount(int delta) {
        this.weaponStorage.update(EWeapon.BALLISTA_BIG, delta);
    }

    @Override
    public void updateBombardAmount(int delta) {
        this.weaponStorage.update(EWeapon.BOMBARD, delta);
    }

    @Override
    public void updateCanonAmount(int delta) {
        this.weaponStorage.update(EWeapon.CANNON, delta);
    }

    @Override
    public void gainExperience() {
        this.experience += 0.005;
    }

    @Override
    public LocalDateTime occupiedUntil() {
        return this.occupied;
    }

    @Override
    public void occupy(LocalDateTime date) {
        Preconditions.checkArgument((boolean)this.date.getCurrentDate().isBefore(date), (Object)"The date must be in the future");
        this.occupied = date;
    }

    @Override
    public double getExperience() {
        return this.experience;
    }
}

