/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.beans.ConstructorProperties;

@ClassCategory(value={EClassCategory.MODEL})
public final class BuyWeapons {
    private final int handWeapons;
    private final int largeWeapons;
    private final int smallWeapons;
    private final int totalStrength;

    @ConstructorProperties(value={"handWeapons", "largeWeapons", "smallWeapons", "totalStrength"})
    BuyWeapons(int handWeapons, int largeWeapons, int smallWeapons, int totalStrength) {
        this.handWeapons = handWeapons;
        this.largeWeapons = largeWeapons;
        this.smallWeapons = smallWeapons;
        this.totalStrength = totalStrength;
    }

    public static BuyWeaponsBuilder builder() {
        return new BuyWeaponsBuilder();
    }

    public int getHandWeapons() {
        return this.handWeapons;
    }

    public int getLargeWeapons() {
        return this.largeWeapons;
    }

    public int getSmallWeapons() {
        return this.smallWeapons;
    }

    public int getTotalStrength() {
        return this.totalStrength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuyWeapons)) {
            return false;
        }
        BuyWeapons other = (BuyWeapons)o;
        if (this.getHandWeapons() != other.getHandWeapons()) {
            return false;
        }
        if (this.getLargeWeapons() != other.getLargeWeapons()) {
            return false;
        }
        if (this.getSmallWeapons() != other.getSmallWeapons()) {
            return false;
        }
        return this.getTotalStrength() == other.getTotalStrength();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHandWeapons();
        result = result * 59 + this.getLargeWeapons();
        result = result * 59 + this.getSmallWeapons();
        result = result * 59 + this.getTotalStrength();
        return result;
    }

    public String toString() {
        return "BuyWeapons(handWeapons=" + this.getHandWeapons() + ", largeWeapons=" + this.getLargeWeapons() + ", smallWeapons=" + this.getSmallWeapons() + ", totalStrength=" + this.getTotalStrength() + ")";
    }

    public static class BuyWeaponsBuilder {
        private int handWeapons;
        private int largeWeapons;
        private int smallWeapons;
        private int totalStrength;

        BuyWeaponsBuilder() {
        }

        public BuyWeaponsBuilder handWeapons(int handWeapons) {
            this.handWeapons = handWeapons;
            return this;
        }

        public BuyWeaponsBuilder largeWeapons(int largeWeapons) {
            this.largeWeapons = largeWeapons;
            return this;
        }

        public BuyWeaponsBuilder smallWeapons(int smallWeapons) {
            this.smallWeapons = smallWeapons;
            return this;
        }

        public BuyWeaponsBuilder totalStrength(int totalStrength) {
            this.totalStrength = totalStrength;
            return this;
        }

        public BuyWeapons build() {
            return new BuyWeapons(this.handWeapons, this.largeWeapons, this.smallWeapons, this.totalStrength);
        }

        public String toString() {
            return "BuyWeapons.BuyWeaponsBuilder(handWeapons=" + this.handWeapons + ", largeWeapons=" + this.largeWeapons + ", smallWeapons=" + this.smallWeapons + ", totalStrength=" + this.totalStrength + ")";
        }
    }
}

