/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ProductionChain {
    private Properties properties = new Properties();

    @PostConstruct
    void init() throws IOException {
        String propertyFileName = "productionchain.properties";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propertyFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propertyFileName + "' not found in the classpath");
        }
        this.properties.load(inputStream);
    }

    public double getProduction(IWare ware) {
        String key = "productionchain.amount." + ware.name();
        return Double.parseDouble(this.properties.getProperty(key));
    }

    public List<IWare> getRequiredWares(IWare wareToBeProduced) {
        String key = "productionchain." + wareToBeProduced.name();
        if (this.properties.containsKey(key)) {
            String value = this.properties.getProperty(key);
            String[] wares = value.split(",");
            ArrayList<IWare> wareList = new ArrayList<IWare>();
            for (String ware : wares) {
                wareList.add(EWare.valueOf(ware));
            }
            return wareList;
        }
        return Collections.emptyList();
    }

    public double getRequiredAmount(IWare wareToBeProduced, IWare requiredWare) {
        String key = "productionchain." + wareToBeProduced.name() + ".amount." + requiredWare.name();
        if (this.properties.containsKey(key)) {
            return Double.parseDouble(this.properties.getProperty(key));
        }
        return 0.0;
    }

    public List<IWare> getWaresWithProductionChain() {
        ArrayList<IWare> list = new ArrayList<IWare>();
        for (EWare ware : EWare.values()) {
            if (this.getRequiredWares(ware).isEmpty()) continue;
            list.add(ware);
        }
        return list;
    }
}

