/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@LazySingleton
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class BlockadeState {
    @MapType(key=ICity.class, value=IBlockade.class)
    private Map<ICity, IBlockade> blockadedCity = new HashMap<ICity, IBlockade>();

    public void addBlockade(ICity city, IBlockade blockade) {
        this.blockadedCity.put(city, blockade);
    }

    public Optional<IBlockade> getBlockade(ICity city) {
        if (this.blockadedCity.containsKey(city)) {
            return Optional.of(this.blockadedCity.get(city));
        }
        return Optional.empty();
    }

    public Set<Map.Entry<ICity, IBlockade>> entrySet() {
        return this.blockadedCity.entrySet();
    }

    public void finishBlockade(ICity city) {
        this.blockadedCity.remove(city);
    }
}

