/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.sea.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.sea.IBlockade;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class Blockade
implements IBlockade {
    @Autowired
    private PlayerList players;
    private final LocalDateTime assemblyDate;
    private final LocalDateTime endBlockade;
    @MapType(key=String.class, value=Integer.class)
    private Map<String, Integer> requestedShips = new HashMap<String, Integer>();
    @MultimapType(key=IPlayer.class, value=IShip.class)
    private Multimap<IPlayer, IShip> ships = ArrayListMultimap.create();
    @ListType(value=IShip.class)
    private List<IShip> shipsToAuction = new ArrayList<IShip>();
    private IConvoy convoy;

    public Blockade(LocalDateTime assemblyDate, LocalDateTime endBlockade) {
        this.assemblyDate = assemblyDate;
        this.endBlockade = endBlockade;
    }

    @Override
    public IConvoy getBlockadeConvoy() {
        return this.convoy;
    }

    @Override
    public List<IShip> getShips(IPlayer player) {
        return new ArrayList<IShip>(this.ships.get((Object)player));
    }

    @Override
    public List<IShip> getShips() {
        return new ArrayList<IShip>(this.ships.values());
    }

    public void requestShip(IPlayer player, int number) {
        this.requestedShips.put(player.getUuid(), number);
    }

    @Override
    public int getNumberOfRequestedShips(IPlayer player) {
        return this.requestedShips.get(player.getUuid());
    }

    @Override
    public List<IPlayer> getPlayersWithRequestedShips() {
        return this.players.stream().filter(player -> this.requestedShips.containsKey(player.getUuid())).collect(Collectors.toList());
    }

    @Override
    public void addShips(IPlayer player, List<IShip> shipList) {
        this.ships.putAll((Object)player, shipList);
    }

    @Override
    public LocalDateTime getAssemblyDate() {
        return this.assemblyDate;
    }

    @Override
    public LocalDateTime getEndBlockade() {
        return this.endBlockade;
    }

    @Override
    public List<IShip> getShipsToAuction() {
        return this.shipsToAuction;
    }

    @Override
    public void setConvoy(IConvoy convoy) {
        this.convoy = convoy;
    }
}

