package ch.sahits.game.openpatrician.model;

import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * Extension of a simple message that is displayed on the noticeboard. More information
 * can be displayed in the form of a dialog defined through a {@link IDialogState}.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 08, 2016
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class DisplayStateMessage extends DisplayMessage {
    @Getter
    private final IDialogState state;

    public DisplayStateMessage(String messageKey, IDialogState state, Object... messageArgs) {
        super(messageKey, messageArgs);
        this.state = state;
    }
}
