package ch.sahits.game.openpatrician.model.city;

/**
 * Model for the church. The church model is very simple as most actions
 * executed on the church do not need any model data.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 21, 2015
 */
public interface IChurch {
    /**
     * Retrieve the next extension level.
     * @return extension level
     */
    EChurchExtension getExtensionLevel();

    /**
     * Upgrade to the next level.
     */
    void upgrade();

    /**
     * Retrieve the amount that was already donated toward the next church extension.
     * @return collected amount of donations for the next extension.
     */
    int getCollectedDonationsForExtension();

    /**
     * Make a donation of <code>amount</code> toward the church extension.
     * @param amount to donate toward the church extension.
     */
    void makeDonation(int amount);
}
