package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import javafx.geometry.Point2D;

/**
 * Capture and destroy a pirates nest.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public interface ICapturePirateNest extends IAldermanTask {
    /**
     * Location of the pirate nest.
     * @return location of the pirate next
     */
    Point2D getLocation();

    /**
     * Retrieve the map with the nest located on it.
     * @return segmented map of the pirate nest.
     */
    MapSegmentedImage getPirateNestMap();
}
