package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.cityhall.IAcceptedAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanOffice;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@Component
@Lazy
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class AldermanOffice implements IAldermanOffice {
    @Getter
    @ListType(IAldermanTask.class)
    private final ObservableList<IAldermanTask> tasks = FXCollections.observableArrayList();
    @Getter
    @Setter
    @OptionalType(ICityViolation.class)
    private Optional<ICityViolation> violation = Optional.empty();
    @Getter
    @ListType(IAcceptedAldermanTask.class)
    private List<IAcceptedAldermanTask> workedOnTasks = new ArrayList<>();


    public void addTask(IAldermanTask task, LocalDateTime limit, IPlayer player) {
        workedOnTasks.add(new AcceptedAldermanTask(task, limit, player));
    }
    public void finished(IAldermanTask task) {
        for (Iterator<IAcceptedAldermanTask> iterator = workedOnTasks.iterator(); iterator.hasNext(); ) {
            IAcceptedAldermanTask next = iterator.next();
            if (task.equals(next.getTask())) {
                iterator.remove();
                break;
            }
        }
    }

}
