package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
@Prototype
public class Treasury implements ITreasury {
    @Value("${base.head.tax}")
    private int baseHeadTax;
    @Value("${base.property.tax}")
    private int basePropertyTax;

    private DoubleProperty currentHeadTaxValue = new SimpleDoubleProperty();
    private DoubleProperty currentPropertyTax = new SimpleDoubleProperty();
    private LongProperty paidTaxes = new SimpleLongProperty(0);
    private LongProperty paidSpecialTaxes = new SimpleLongProperty(0);
    private IntegerProperty cityGuardCosts = new SimpleIntegerProperty(0);
    private IntegerProperty buildingCosts = new SimpleIntegerProperty(0);
    private IntegerProperty outriggerCosts = new SimpleIntegerProperty(0);
    private IntegerProperty siegeCosts = new SimpleIntegerProperty(0);
    private IntegerProperty otherCosts = new SimpleIntegerProperty(0);
    private IntegerProperty otherIncome = new SimpleIntegerProperty(0);
    private IntegerProperty donations = new SimpleIntegerProperty(0);
    private LongProperty cash = new SimpleLongProperty(0);
    @PostConstruct
    private void init() {
        currentHeadTaxValue.setValue(baseHeadTax);
        currentPropertyTax.setValue(basePropertyTax);
    }



    /**
     * Reset all the moneytary values save cash back to 0.
      */
    public void reset() {
       paidTaxes.setValue(0);
        paidSpecialTaxes.setValue(0);
        cityGuardCosts.setValue(0);
        buildingCosts.setValue(0);
        outriggerCosts.setValue(0);
        siegeCosts.setValue(0);
        otherIncome.setValue(0);
        otherCosts.setValue(0);
        donations.setValue(0);
    }

    public void setCurrentHeadTaxValue(double currentHeadTaxValue) {
        this.currentHeadTaxValue.setValue(currentHeadTaxValue);
    }

//    public void setCurrentPropertyTax(double currentPropertyTax) {
//        this.currentPropertyTax.setValue(currentPropertyTax);
//    }

    public void addPaidTaxes(long paidTaxes) {
        Platform.runLater(() -> {
            this.paidTaxes.setValue(this.paidTaxes.longValue() + paidTaxes);
            cash.setValue(cash.get() + paidTaxes);
        });
    }

    public void addPaidSpecialTaxes(long paidSpecialTaxes) {
        Platform.runLater(() -> {
            this.paidSpecialTaxes.setValue(this.paidSpecialTaxes.longValue() + paidSpecialTaxes);
            cash.setValue(cash.get() + paidSpecialTaxes);
        });
    }

    public void subtractCityGuardCosts(int cityGuardCosts) {
        Platform.runLater(() -> {
            this.cityGuardCosts.setValue(this.cityGuardCosts.intValue() - cityGuardCosts);
            cash.setValue(cash.get() - cityGuardCosts);
        });
    }

    public void subtractBuildingCosts(int buildingCosts) {
        Platform.runLater(() -> {
            this.buildingCosts.setValue(this.buildingCosts.intValue() - buildingCosts);
            cash.setValue(cash.get() - buildingCosts);
        });
    }

    public void subtractOutriggerCosts(int outriggerCosts) {
        Platform.runLater(() -> {
            this.outriggerCosts.setValue(this.outriggerCosts.intValue() - outriggerCosts);
            cash.setValue(cash.get() - outriggerCosts);
        });
    }

    public void subtractSiegeCosts(int siegeCosts) {
        Platform.runLater(() -> {
            this.siegeCosts.setValue(this.siegeCosts.intValue() - siegeCosts);
            cash.setValue(cash.get() - siegeCosts);
        });
    }

    public void subtractOtherCosts(int otherCosts) {
        Platform.runLater(() -> {
            this.otherCosts.setValue(this.otherCosts.intValue() - otherCosts);
            cash.setValue(cash.get() - otherCosts);
        });
    }

    public void addOtherIncome(int otherIncome) {
        Platform.runLater(() -> {
            this.otherIncome.setValue(this.otherIncome.intValue() + otherIncome);
            cash.setValue(cash.get() + otherIncome);
        });
    }

    public void addDonations(int donations) {
        Platform.runLater(() -> {
            this.donations.setValue(this.donations.intValue() + donations);
            cash.setValue(cash.get() + donations);
        });

    }

    @Override
    public long getCash() {
        return cash.get();
    }

    public LongProperty cashProperty() {
        return cash;
    }

    public void setCash(long cash) {
        this.cash.set(cash);
    }

    public DoubleProperty currentHeadTaxValueProperty() {
        return currentHeadTaxValue;
    }

    public DoubleProperty currentPropertyTaxProperty() {
        return currentPropertyTax;
    }

    public LongProperty paidTaxesProperty() {
        return paidTaxes;
    }

    public LongProperty paidSpecialTaxesProperty() {
        return paidSpecialTaxes;
    }

    public IntegerProperty cityGuardCostsProperty() {
        return cityGuardCosts;
    }

    public IntegerProperty buildingCostsProperty() {
        return buildingCosts;
    }

    public IntegerProperty outriggerCostsProperty() {
        return outriggerCosts;
    }

    public IntegerProperty siegeCostsProperty() {
        return siegeCosts;
    }

    public IntegerProperty otherCostsProperty() {
        return otherCosts;
    }

    public IntegerProperty otherIncomeProperty() {
        return otherIncome;
    }

    public IntegerProperty donationsProperty() {
        return donations;
    }


    @Override
    public double getCurrentHeadTaxValue() {
        return currentHeadTaxValue.get();
    }

    @Override
    public double getCurrentPropertyTax() {
        return currentPropertyTax.get();
    }

    @Override
    public long getPaidTaxes() {
        return paidTaxes.get();
    }

    @Override
    public long getPaidSpecialTaxes() {
        return paidSpecialTaxes.get();
    }

    @Override
    public int getCityGuardCosts() {
        return cityGuardCosts.get();
    }

    @Override
    public int getBuildingCosts() {
        return buildingCosts.get();
    }

    @Override
    public int getOutriggerCosts() {
        return outriggerCosts.get();
    }

    @Override
    public int getSiegeCosts() {
        return siegeCosts.get();
    }

    @Override
    public int getOtherCosts() {
        return otherCosts.get();
    }

    @Override
    public int getOtherIncome() {
        return otherIncome.get();
    }

    @Override
    public int getDonations() {
        return donations.get();
    }
}
