package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.utilities.CancelableRunnable;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

/**
 * Base model for the next auction hold in the guild.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 */
public interface IAuction {
    /**
     * Retrieve the date of the auction.
     * @return date of the auction
     */
    LocalDateTime getAuctionDate();

    /**
     * Set the auction date.
     * @param newDate date of the action
     */
    void setAuctionDate(LocalDateTime newDate);

    /**
     * Retrieve the first bid amount.
     * @return initial bid of the auction
     */
    int getStartingBid();

    /**
     * Get the owner that is auctioning.
     * @return if the auctioned item has an owner supply him
     */
    Optional<IPlayer> getOwner();

    /**
     * Retrieve the current bid level.
     * @return current bid level
     */
    EBidLevel getBidLevel();

    /**
     * Set the new bid level.
     * @param level bid level
     */
    void setBidLevel(EBidLevel level);

    /**
     * Retrieve the currently bidding player.
      * @return player with the highest bid
     */
    IPlayer getBiddingPlayer();

    /**
     * Set the currently bidding player.
     * @param player player with the highest bid.
     */
    void setBiddingPlayer(IPlayer player);

    /**
     * Retrieve the current bid of the bidding player.
     * @return current bid
     */
    int getCurrentBid();

    /**
     * Set the current bid.
     * @param bid current bid
     */
    void setCurrentBid(int bid);

    /**
     * Retrieve the list of AI players that can bid.
     * @return list of {@link ch.sahits.game.openpatrician.model.impl.AIPlayer}s bidding
     */
    List<IAIPlayer> getBiddingPlayers();

    /**
     * Define the list of AI player that can bid.
     * @param players list of {@link ch.sahits.game.openpatrician.model.impl.AIPlayer}s bidding
     */
    void setBiddingPlayers(List<IAIPlayer> players);

    /**
     * Retrieve the current task.
      * @return task for the auction
     */
    CancelableRunnable getCurrentTask();

    /**
     * Set the current task
     * @param task of the auction
     */
    void setCurrentTask(CancelableRunnable task);
}
