package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.city.ECityWall;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;
import lombok.Setter;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * This is a simple model for the city wall.
 * Later on this class will be replaced by a subclass of IBuilding.
 * This class helps in keeping track of the city wall building process.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jun 05, 2015
 */
@Component
@Scope("prototype")
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class CityWall {
    @Getter
    @Setter
    private ECityWall extension = ECityWall.NOT_EXTENDED;
    @Getter
    @Setter
    private int requiredBricks = 0;
    @Getter
    @Setter
    private int boughtBricks = 0;
    @Getter
    @Setter
    private int usedBricks = 0;
}
