package ch.sahits.game.openpatrician.model.event;

/**
 * Enumeration mapping the various events (e.g. celebration, fire, plague)
 * to a media file.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 *         Created on Jan 04, 2017
 */
public enum EEventMediaType {
    PLAGUE("video/event/BlackDeath.mp4"),
    CELEBRATION("video/event/celebration.mp4"),
    FIRE("video/event/fire.mp4"),
    HANSEATIC_LEAGUE("video/event/hanseaticLeague.mp4"),
    PIRATE_ATTACK("video/event/pirateAttack.mp4");

    private final String resource;

    EEventMediaType(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return resource;
    }
}
