package ch.sahits.game.openpatrician.model.event;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Abstract task class to be used with a SheduledExecutorService.
 *
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jan 12, 2016
 */
public abstract class SchedulableTask implements Runnable {
    private final Logger logger = LogManager.getLogger(getClass());

    /**
     * This method is called every time the task is scheduled to run.
     * @param now current time in milliseconds.
     */
    public abstract void handle(long now);

    @Override
    public void run() {
        try {
            long now = System.currentTimeMillis();
            handle(now);
        } catch (Exception e) {
          logger.warn("Failed to execute the task due to exception", e);
        }
    }
}
