package ch.sahits.game.openpatrician.model.impl;

import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.player.EPlayerColor;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 12, 2015
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class HumanPlayer extends Player implements IHumanPlayer {
    @Getter
    private final EPlayerColor color;
    public HumanPlayer(ICity homeTown, IPersonalData personalData, ESocialRank rank, ICompany company, EPlayerColor color) {
        super(homeTown, personalData, rank, company);
        this.color = color;
    }
}
