package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.IPlayer;


/**
 * Another player asking to harm his concurrent by sinking
 * one of his ships.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface IConcurrent extends ISideRoomPerson {
	/**
	 * Name of the client
	 * @return name of the concurrent
	 */
	String getName();
	/**
	 * Name of the concurrent who is to be harmed.
	 * @return of the concurrent
	 */
	String getConcurrentName();
	/**
	 * Get the player that is the client
	 * @return player instance who issues the contract.
	 */
	IPlayer getClientPlayer();
	/**
	 * Retrieve the concurrent player
	 * @return player instance of the concurrent.
	 */
	IPlayer getConcurrentPlayer();
	/**
	 * Promissed premium.
	 * @return premium for successful exection.
	 */
	int getPremium();

	/**
	 * Set the player instance accepting the contract
	 * @param clientPlayer player executin the contract
	 */
	void setClientPlayer(IPlayer clientPlayer);

	/**
	 * Set the player, who is the concurrent
	 * @param concurrentPlayer concurrent player.
	 */
	void setConcurrentPlayer(IPlayer concurrentPlayer);

	/**
	 * Set the premium
	 * @param premium for successful completion.
	 */
	void setPremium(int premium);
}
