package ch.sahits.game.openpatrician.model.people;

import ch.sahits.game.openpatrician.model.city.ICity;


/**
 * Defining a trader with missing ships capacities, who has
 * to get to another city with his wares.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Jan 27, 2013
 *
 */
public interface ITransportTrader extends ISideRoomPerson {
	/**
	 * Retrieve the name of the trader.
	 * @return name of the trader.
	 */
	String getName();
	/**
	 * Destination city the trader has to get to.
	 * @return destination city
	 */
	ICity getDestination();
	/**
	 * Retrieve the needed capacity in bales for the transport.
	 * @return requred capacity in bales
	 */
	int getNeededCapacity();
	/**
	 * Retrieve the premium.
	 * @return promised premium upon completion.
	 */
	int getPremium();

	/**
	 * Set the name of the transport trader.
	 * @param name of the trader
	 */
	void setName(String name);

	/**
	 * Set the destination city
	 * @param destination city
	 */
	void setDestination(ICity destination);

	/**
	 * Set the promised premium
	 * @param premium to be payed upon completion.
	 */
	void setPremium(int premium);

	 void setNeededCapacity(int neededCapacity);
}
