package ch.sahits.game.openpatrician.model.people.impl;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import lombok.Getter;

import java.time.LocalDateTime;
import java.util.Optional;

/**
 * Implementation of a non free pirate.
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class NonFreeSeaPirate extends SeaPirate implements INonFreeSeaPirate {
  @OptionalType(ICity.class)
  private final Optional<ICity> nearCity;
  @Getter
  private final IPlayer hiringPlayer;
  @Getter
  private final LocalDateTime hireDate;

  /**
   * Create a non free pirate.
   * @param hiringPlayer player who hired the pirate
   * @param hireDate date on which the pirate was hired
   * @param nearCity if the pirate should operate near a city indicate it here, otherwise null.
   */
  public NonFreeSeaPirate(IPlayer hiringPlayer, LocalDateTime hireDate, ICity nearCity) {
    this.nearCity = Optional.ofNullable(nearCity);
    this.hiringPlayer = hiringPlayer;
    this.hireDate = hireDate;
  }

  @Override
  public Optional<ICity> roamingNearCity() {
    return nearCity;
  }
}
