package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.MultimapType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

import java.util.ArrayList;
import java.util.List;

/**
 * Context holding data for various trade strategies for an AIPlayer.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Oct 05, 2017
 */
@Prototype
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class AIPlayerContext {
    @MultimapType(key = ICity.class, value = ITradeStategyHint.class)
    private Multimap<ICity, ITradeStategyHint> hints = ArrayListMultimap.create();
    @ListType(BaseStrategyType.class)
    private List<BaseStrategyType<?>> generalStrategyTypes = new ArrayList<>();

    /**
     * Add a new hint to a city.
     * @param city for which to add the hint
     * @param hint to be added
     */
    public void add(ICity city, ITradeStategyHint hint) {
        hints.put(city, hint);
    }

    /**
     * Retrieve all hints for the city.
     * @param city for which to retrieve the hints
     * @return list of city hints.
     */
    public List<ITradeStategyHint>  getHints(ICity city) {
        return new ArrayList<>(hints.get(city));
    }

    public List<BaseStrategyType<?>> getGeneralStrategyTypes() {
        return new ArrayList<>(generalStrategyTypes);
    }

    /**
     * Add a new stategy type.
     * @param strategyType type of the strategy to be added
     */
    public void add(BaseStrategyType<?> strategyType) {
        generalStrategyTypes.add(strategyType);
    }
}
