package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.ship.IShip;

import java.util.Optional;

/**
 * Strategy defines if a captain should be hired.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Jul 31, 2016
 */
public interface IAICaptainHireStrategy {
    /**
     * Should <code>player</code> hire <code>captain</code> on the <code>vessel</code>.
     * @param player making the decision
     * @param vessel on which the captain would end up
     * @param city where the potential captain can be hired.
     * @return true if the captain should be hired
     */
    boolean shouldHire(IAIPlayer player, IShip vessel, ICity city);

    /**
     * Retrieve the captain to be hired.
     * @param city where the potential captain can be hired.
     * @return Optional captain. Will return empty if there is no captain in the city.
     */
    Optional<ICaptain> getCaptain(ICity city);

    /**
     * <code>player</code> hires <code>captain</code> on the <code>vessel</code>.
     * @param player doing the hiring
     * @param vessel of the captian
     * @param captain who is hired.
     * @param city where the captain is hired.
     */
    void hire(IAIPlayer player, IShip vessel, ICaptain captain, ICity city);
}
