package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Strategy defining how many sailors belong onto a ship. If the number is lower than already on it, additional
 * sailors can be hired.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Nov 04, 2017
 */
public interface IAIHireSailorStrategy {

    /**
     * Calculate the number of required sailors on the ship.
     * @param ship for which the number has to be calculated.
     * @param player owning the ship
     * @return number of sailors that should be on the ship.
     */
    int calculateRequiredSailorAmount(IShip ship, IAIPlayer player);
}
