package ch.sahits.game.openpatrician.model.player;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Strategy for upgrading the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Nov 04, 2017
 */
public interface IAIShipUpgradeStrategy {
    /**
     * Check if the ship should be upgraded.
     * @param ship that should be checked for upgrading
     * @return true if the ship should be upgraded
     */
    boolean shouldUpgrade(IShip ship);

    /**
     * Upgrade the ship in city.
     * @param ship to upgrade
     * @param city in which the ship should be upgraded
     */
    void upgrade(IShip ship, ICity city);
}
