package ch.sahits.game.openpatrician.model.player;

import java.util.List;

/**
 * Interface for providing the various strategies for the AI.
 */
public interface IAIStrategyProvider {
    /**
     * Provide a list of AI strategy types for the trading.
     * @return list of trade strategy types
     */
    List<IAITradeStrategyType> getTradeStrategies();

    /**
     * Provide a list of repair strategy types.
     * @return list of ship repair strategy types
     */
    List<IAIShipRepairStrategyType> getRepairStrategies();

    /**
     * Provide a list of take loan strategies.
     * @return list of loan taking strategy types
     */
    List<IAITakeLoanStrategyType> getTakeLoanStrategies();

    /**
     * Provide a list of strategies to select a ship construction strategy.
     * @return list of ship construction strategy types
     */
    List<IAIConstructionSelectionStrategyType> getConstructionSelectionStrategies();

    /**
     * Provide a list of strategies to hire a captain.
     * @return list of hairing captain strategy types
     */
    List<IAICaptainHireStrategyType> getCaptainHireStrategies();

    /**
     * Provide a list of strategies to join a guild.
     * @return list of joining guilds strategy types
     */
    List<IAIGuildJoinStrategyType> getGuildJoinStrategies();

    /**
     * Provide a list of strategies to decide on events.
     * @return list of event decision strategy types
     */
    List<IAIEventDecisionStrategyType> getEventDecisionStrategies();

    /**
     * Provide a list of strategies for hiring and dismissing trage managers.
     * @return list of strategy types to hire trade managers
     */
    List<IAIHireTradeManagerStrategyType> getHireTradeManagerStrategies();

    /**
     * Provide a list of strategies for buying weapons.
     * @return list of strategy types to buy weapons
     */
    List<IAIBuyWeaponStrategyType> getWeaponBuyStrategies();

    /**
     * Provide a list of strategies for hiring sailors.
     * @return list of strategy types to hire sailors
     */
    List<IAIHireSailorsStrategyType> getHireSailorStrategies();

    /**
     * Retrieve a list of strategies to upgrade a ship.
     * @return list of strategy types to upgrade ships.
     */
    List<IAIShipUpgradeStrategyType> getShipUpgradeStrategies();
}
