package ch.sahits.game.openpatrician.model.product;

import ch.sahits.game.openpatrician.model.city.ECityState;
import ch.sahits.game.openpatrician.model.city.IPopulationStructure;


/**
 * This interface defines the price calculation algorithm.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jan 16, 2011
 *
 */
public interface IPriceCalculation {
	/**
	 * Compute the price for one item of the ware. Though the price is only handled in further
	 * computation as integer value, this method returns its value as double so this condition can be
	 * tested:<br>
	 * The higher the available amount (but still below the saturation value) the smaller (strictly) the returned
	 * value.<br>
	 * For different starting values:<br>
	 * If  the starting value b is below starting point a the whole curve of b is below (not necessary strictly)
	 * the curve of a. The curve is continues between 0 (inclusive) and infinity.
	 * @param min the lowest possible price (0 exclusive)
	 * @param max the highest possible price
	 * @param available amount of wares that are available in the market
	 * @param saturation amount of items at which the market is saturated (no further price change
	 * @param productionRate amount the city can produce within a week
	 * @param pop population structure that may have an influence on the calculated price
	 * @param state state of the city
	 * @return price for one item sold
	 */
	double computePrice(int min, int max, int available, int saturation, int productionRate, IPopulationStructure pop, ECityState state);

}
