package ch.sahits.game.openpatrician.model.sea;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;

import java.time.LocalDateTime;
import java.util.List;

/**
 * State of a single blockade.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 14, 2016
 */
public interface IBlockade {
    /**
     * Date when the convoy is assembled to travel to the city to be blockaded.
     * @return date when the fleet is assembled for the blockade
     */
    LocalDateTime getAssemblyDate();

    /**
     * End date of the blockade.
     * @return date when the blockade ends
     */
    LocalDateTime getEndBlockade();

    /**
     * Retrieve the blockade convoy
     * @return convoy fleet executing the blockade
     */
    IConvoy getBlockadeConvoy();

    /**
     * Retrieve the ships of a certain player.
     * @param player for which to retrieve the ships
     * @return List of ships of the player in the blockade convoy
     */
    List<IShip> getShips(IPlayer player);
    /**
     * Retrieve all ships for the blockade.
     * @return list of ships in the convoy.
     */
    List<IShip> getShips();

    /**
     * Retrieve a list of players which have requested a ship
     * @return list of player who should provide ships for the blockade convoy
     */
    List<IPlayer> getPlayersWithRequestedShips();

    /**
     * Retrieve the number of ships that are requested.
     * @param player for whom to retrieve the number of requested ships
     * @return number of requested ships from <code>player</code>
     */
    int getNumberOfRequestedShips(IPlayer player);

    /**
     * Add a number of ships for a player to the blockade.
     * @param player for whom to add ships to the blockade convoy
     * @param shipList list of ships to be added
     */
    void addShips(IPlayer player, List<IShip> shipList);

    /**
     * Set the convoy.
     * @param convoy for the blockade
     */
    void setConvoy(IConvoy convoy);

    /**
     * List containing ships that were captured during the blockade mission,
     * that will be auctioned at the end.
     * @return list of ships that are auctioned after blockade end.
     */
    List<IShip> getShipsToAuction();


}
