package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import javafx.geometry.Point2D;

import java.util.ArrayList;
import java.util.List;

/**
 * List of all convois.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 07, 2016
 */
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
@LazySingleton
public class ConvoyList {
    @ListType(IConvoy.class)
    private List<IConvoy> convois = new ArrayList<>();

    public boolean add(IConvoy iConvoy) {
        return convois.add(iConvoy);
    }

    public boolean remove(Object o) {
        return convois.remove(o);
    }

    /**
     * Find all convois in town.
     * @param city for which to find convoys
     * @return list ov convoys in the city.
     */
    public List<IConvoy> findConvoy(ICity city) {
        Point2D location = city.getCoordinates();
        ArrayList<IConvoy> inTown = new ArrayList<>();
        for (IConvoy convoy : convois) {
            if (convoy.getLocation().equals(location)) {
                inTown.add(convoy);
            }
        }
        return inTown;
    }
}
