package ch.sahits.game.openpatrician.model.ship;

import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import javafx.geometry.Point2D;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;

import java.util.Optional;

/**
 * Weapon slot for a small weapon.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 * Created on Aug 15, 2017
 */
@Getter
@RequiredArgsConstructor
@ClassCategory(EClassCategory.MODEL)
public class SmallWeaponSlot implements IWeaponSlot {
    private final ESide side;
    private final int id;
    @OptionalType(IWeapon.class)
    private Optional<IWeapon> weapon = Optional.empty();
    @Setter
    private Point2D offset;

    /**
     * Place a small weapon in the slot. If null is passed the slot is emptied.
     * @param weapon to be placed
     */
    public void setWeapon(IWeapon weapon) {
        if (weapon == null) {
            this.weapon = Optional.empty();
        } else {
            assertWeaponType(weapon);
            this.weapon = Optional.of(weapon);
        }
    }

    private void assertWeaponType(IWeapon weapon) {
        if (weapon instanceof EWeapon) {
            EWeapon w = (EWeapon) weapon;
            if (w != EWeapon.TREBUCHET_SMALL
                    && w != EWeapon.BALLISTA_SMALL
                    && w != EWeapon.CANNON) {
                throw new IllegalArgumentException("The 'weapon' is not small");
            }
        } else {
            throw new IllegalArgumentException("'weapon' must be of type EWeapon");
        }
    }

}
