package ch.sahits.game.openpatrician.model.ui;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Dec 26, 2015
 */
@ClassCategory(EClassCategory.MODEL)
@LazySingleton
public class MapState {
    private BooleanProperty miniMapShowingSea = new SimpleBooleanProperty(this, "miniMapSowingSea", true);
    private BooleanProperty showingLargeSeaMap = new SimpleBooleanProperty(this, "showingLargeSeaMap", false);

    public boolean isMiniMapShowingSea() {
        return miniMapShowingSea.get();
    }

    public BooleanProperty miniMapShowingSeaProperty() {
        return miniMapShowingSea;
    }

    public void setMiniMapShowingSea(boolean miniMapShowingSea) {
        this.miniMapShowingSea.set(miniMapShowingSea);
    }

    public boolean showingLargeSeaMap() {
        return showingLargeSeaMap.get();
    }

    public BooleanProperty showingLargeSeaMapProperty() {
        return showingLargeSeaMap;
    }

    public void setShowingLargeSeaMap(boolean showingLargeSeaMap) {
        this.showingLargeSeaMap.set(showingLargeSeaMap);
    }
}
