package ch.sahits.game.openpatrician.model.weapon;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

/**
 * Registry for mapping the armory to the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2017
 *         Created on Jul 27, 2017
 */
@LazySingleton
@ClassCategory({EClassCategory.SINGLETON_BEAN, EClassCategory.SERIALIZABLE_BEAN})
public class ArmoryRegistry implements Iterable<Entry<ICity, IArmory>> {
    @MapType(key = ICity.class, value = IArmory.class)
    private final HashMap<ICity, IArmory> armoryMap = new HashMap<>();

    /**
     * Add a new armory for a city.
     * @param city for which to add the armory
     * @param armory to be added
     */
    public void add(ICity city, IArmory armory) {
        armoryMap.put(city, armory);
    }

    /**
     * Retrieve the armory of the city.
     * @param city for which to retrieve the armory
     * @return amrory in the respective city
     */
    public IArmory getArmory(ICity city) {
        return armoryMap.get(city);
    }

    @Override
    public Iterator<Entry<ICity, IArmory>> iterator() {
        return armoryMap.entrySet().iterator();
    }
}
