/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class LoanRequest
implements ILoanRequest {
    private final LocalDateTime issued;
    private final ICitizen citizen;
    private final int durationInWeeks;
    private final int sum;

    @Override
    public LocalDateTime issued() {
        return this.issued;
    }

    public static LoanRequestBuilder builder() {
        return new LoanRequestBuilder();
    }

    public LoanRequest(LocalDateTime issued, ICitizen citizen, int durationInWeeks, int sum) {
        this.issued = issued;
        this.citizen = citizen;
        this.durationInWeeks = durationInWeeks;
        this.sum = sum;
    }

    @Override
    public ICitizen getCitizen() {
        return this.citizen;
    }

    @Override
    public int getDurationInWeeks() {
        return this.durationInWeeks;
    }

    @Override
    public int getSum() {
        return this.sum;
    }

    public static class LoanRequestBuilder {
        private LocalDateTime issued;
        private ICitizen citizen;
        private int durationInWeeks;
        private int sum;

        LoanRequestBuilder() {
        }

        public LoanRequestBuilder issued(LocalDateTime issued) {
            this.issued = issued;
            return this;
        }

        public LoanRequestBuilder citizen(ICitizen citizen) {
            this.citizen = citizen;
            return this;
        }

        public LoanRequestBuilder durationInWeeks(int durationInWeeks) {
            this.durationInWeeks = durationInWeeks;
            return this;
        }

        public LoanRequestBuilder sum(int sum) {
            this.sum = sum;
            return this;
        }

        public LoanRequest build() {
            return new LoanRequest(this.issued, this.citizen, this.durationInWeeks, this.sum);
        }

        public String toString() {
            return "LoanRequest.LoanRequestBuilder(issued=" + this.issued + ", citizen=" + this.citizen + ", durationInWeeks=" + this.durationInWeeks + ", sum=" + this.sum + ")";
        }
    }
}

