/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.personal.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;
import java.time.Period;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class PersonalData
implements IPersonalData {
    private final String name;
    private final String lastName;
    private final boolean male;
    private final ICity birthPlace;
    private final LocalDateTime birthDate;

    @Override
    public int getAge(LocalDateTime now) {
        return Period.between(this.birthDate.toLocalDate(), now.toLocalDate()).getYears();
    }

    public PersonalData(String name, String lastName, boolean male, ICity birthPlace, LocalDateTime birthDate) {
        this.name = name;
        this.lastName = lastName;
        this.male = male;
        this.birthPlace = birthPlace;
        this.birthDate = birthDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public boolean isMale() {
        return this.male;
    }

    @Override
    public ICity getBirthPlace() {
        return this.birthPlace;
    }

    @Override
    public LocalDateTime getBirthDate() {
        return this.birthDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonalData)) {
            return false;
        }
        PersonalData other = (PersonalData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        if (this.isMale() != other.isMale()) {
            return false;
        }
        ICity this$birthPlace = this.getBirthPlace();
        ICity other$birthPlace = other.getBirthPlace();
        if (this$birthPlace == null ? other$birthPlace != null : !this$birthPlace.equals(other$birthPlace)) {
            return false;
        }
        LocalDateTime this$birthDate = this.getBirthDate();
        LocalDateTime other$birthDate = other.getBirthDate();
        return !(this$birthDate == null ? other$birthDate != null : !((Object)this$birthDate).equals(other$birthDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersonalData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        result = result * 59 + (this.isMale() ? 79 : 97);
        ICity $birthPlace = this.getBirthPlace();
        result = result * 59 + ($birthPlace == null ? 43 : $birthPlace.hashCode());
        LocalDateTime $birthDate = this.getBirthDate();
        result = result * 59 + ($birthDate == null ? 43 : ((Object)$birthDate).hashCode());
        return result;
    }

    public String toString() {
        return "PersonalData(name=" + this.getName() + ", lastName=" + this.getLastName() + ", male=" + this.isMale() + ", birthPlace=" + this.getBirthPlace() + ", birthDate=" + this.getBirthDate() + ")";
    }
}

