/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.ship.impl;

import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.ShipProperties;
import ch.sahits.game.openpatrician.model.ship.impl.Ship;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class Cog
extends Ship
implements ICog {
    @Autowired
    @XStreamOmitField
    private ShipProperties shipProperties;
    @Autowired
    @XStreamOmitField
    private ShipWeaponsLocationFactory weaponsLocationFactory;

    public Cog(EShipUpgrade upgradeLevel, String name) {
        this.shipUpgradeLevel = upgradeLevel;
        this.name = name;
    }

    public Cog(String name) {
        this(EShipUpgrade.NONE, name);
    }

    @PostConstruct
    private void init() {
        super.initializeProperties(this.shipProperties.getCog());
        this.setWeaponSlots(this.weaponsLocationFactory.getShipWeaponsLocation(EShipType.COG, this.shipUpgradeLevel));
    }

    @Override
    public EShipType getShipType() {
        return EShipType.COG;
    }
}

