/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.model.city.EChurchExtension;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ChurchState
implements IChurch {
    @XStreamOmitField
    private static final Logger LOGGER = LogManager.getLogger(ChurchState.class);
    private EChurchExtension extensionLevel = EChurchExtension.NONE;
    private int collectedDonationsForExtension = 0;

    @Override
    public void upgrade() {
        Optional<EChurchExtension> next = this.extensionLevel.getNextExtensionLevel();
        if (next.isPresent()) {
            this.extensionLevel = next.get();
            this.collectedDonationsForExtension = 0;
        } else {
            LOGGER.warn("Church cannot be extended as it is already extended to its max level.");
        }
    }

    @Override
    public void makeDonation(int amount) {
        this.collectedDonationsForExtension += amount;
    }

    @Override
    public EChurchExtension getExtensionLevel() {
        return this.extensionLevel;
    }

    @Override
    public int getCollectedDonationsForExtension() {
        return this.collectedDonationsForExtension;
    }
}

