/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.datastructure.GenericPair;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.initialisation.MapInitializedBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.MapType;
import com.google.common.collect.ImmutableList;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=MapInitializedBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class CitiesState {
    @Autowired
    private IMap map;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @MapType(key=ICity.class, value=CityState.class)
    private ConcurrentHashMap<ICity, CityState> cities = new ConcurrentHashMap();

    public void init() {
        for (ICity city : this.map.getCities()) {
            if (this.cities.get(city) != null) continue;
            this.addCity(city, city.getCityState());
        }
    }

    public void addCity(ICity city, CityState cityState) {
        this.cities.put(city, cityState);
    }

    public Optional<GenericPair<ICity, IWare>> findCityWithMostNeededWare() {
        ArrayList all = new ArrayList();
        for (CityState state : this.cities.values()) {
            Optional<IWare> ware = state.findMostNeededWare();
            ware.ifPresent(iWare -> all.add(new GenericPair((Object)state.getCity(), iWare)));
        }
        if (all.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((GenericPair)all.get(this.rnd.nextInt(all.size())));
    }

    public Optional<GenericPair<ICity, IWare>> findCityWithSurplusWare() {
        ArrayList all = new ArrayList();
        for (CityState state : this.cities.values()) {
            Optional<IWare> ware = state.findWareWithMostSurplus();
            ware.ifPresent(iWare -> all.add(new GenericPair((Object)state.getCity(), iWare)));
        }
        if (all.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((GenericPair)all.get(this.rnd.nextInt(all.size())));
    }

    public List<CityState> getCityEngineStates() {
        return ImmutableList.copyOf(this.cities.values());
    }
}

