/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.model.service.persistance.converter;

import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class WareMapConverter
extends AbstractCollectionConverter {
    public static final String INT_ENTRY_NAME = "wareIntMapEntry";
    public static final String DOUBLE_ENTRY_NAME = "wareDoubleMapEntry";
    public static final String AMOUNTABLEPRICE_ENTRY_NAME = "wareAmountablePriceMapEntry";

    public WareMapConverter(Mapper mapper) {
        super(mapper);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)source;
        if (map.isEmpty()) {
            this.marshall(writer, context, map);
        } else {
            Object firstKey = map.keySet().iterator().next();
            Object firstValue = map.get(firstKey);
            if (firstKey instanceof EWare && (firstValue instanceof Integer || firstValue instanceof Double || firstValue instanceof AmountablePrice)) {
                if (firstValue instanceof Integer) {
                    for (Object o : map.keySet()) {
                        EWare ware = (EWare)o;
                        int value = (Integer)map.get(ware);
                        this.marshallMapEntry(writer, INT_ENTRY_NAME, ware.name(), String.valueOf(value));
                    }
                } else if (firstValue instanceof Double) {
                    for (Object o : map.keySet()) {
                        EWare ware = (EWare)o;
                        double value = (Double)map.get(ware);
                        this.marshallMapEntry(writer, DOUBLE_ENTRY_NAME, ware.name(), String.valueOf(value));
                    }
                } else {
                    for (Object o : map.keySet()) {
                        EWare ware = (EWare)o;
                        AmountablePrice value = (AmountablePrice)map.get(ware);
                        this.marshallAmountablePriceMapEntry(writer, AMOUNTABLEPRICE_ENTRY_NAME, ware.name(), value.getAmount(), value.getSum());
                    }
                }
            } else {
                this.marshall(writer, context, map);
            }
        }
    }

    private void marshallAmountablePriceMapEntry(HierarchicalStreamWriter writer, String entryName, String name, int amount, double avgPrice) {
        writer.startNode(entryName);
        writer.addAttribute("ware", name);
        writer.addAttribute("amount", String.valueOf(amount));
        writer.addAttribute("avgPrice", String.valueOf(avgPrice));
        writer.endNode();
    }

    private void marshall(HierarchicalStreamWriter writer, MarshallingContext context, Map map) {
        String entryName = this.mapper().serializedClass(Map.Entry.class);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.marschallMapEntry(writer, context, entryName, entry);
        }
    }

    private void marschallMapEntry(HierarchicalStreamWriter writer, MarshallingContext context, String entryName, Map.Entry entry) {
        ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)entryName, entry.getClass());
        this.writeItem(entry.getKey(), context, writer);
        this.writeItem(entry.getValue(), context, writer);
        writer.endNode();
    }

    private void marshallMapEntry(HierarchicalStreamWriter writer, String entryName, String name, String value3) {
        writer.startNode(entryName);
        writer.addAttribute("ware", name);
        writer.addAttribute("value", value3);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map map = (Map)this.createCollection(context.getRequiredType());
        this.populateMap(reader, context, map);
        return map;
    }

    private void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map) {
        this.populateMap(reader, context, map, map);
    }

    private void populateMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
        while (reader.hasMoreChildren()) {
            String nodeName;
            reader.moveDown();
            switch (nodeName = reader.getNodeName()) {
                case "wareIntMapEntry": 
                case "wareDoubleMapEntry": {
                    this.putCurrentEntryIntoMap(reader, context, map, target, nodeName);
                    break;
                }
                case "wareAmountablePriceMapEntry": {
                    this.putCurrentAmountablePriceEntryIntoMap(reader, context, map, target, nodeName);
                    break;
                }
                default: {
                    this.putCurrentEntryIntoMap(reader, context, map, target);
                }
            }
            reader.moveUp();
        }
    }

    private void putCurrentAmountablePriceEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target, String nodeName) {
        EWare key = EWare.valueOf(reader.getAttribute("ware"));
        int amount = Integer.parseInt(reader.getAttribute("amount"));
        double avgPrice = Double.parseDouble(reader.getAttribute("avgPrice"));
        AmountablePrice amountablePrice = new AmountablePrice(amount, avgPrice);
        target.put(key, amountablePrice);
    }

    private void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target, String nodeName) {
        EWare key = EWare.valueOf(reader.getAttribute("ware"));
        Number value = nodeName.equals(INT_ENTRY_NAME) ? (Number)Integer.parseInt(reader.getAttribute("value")) : (Number)Double.parseDouble(reader.getAttribute("value"));
        target.put(key, value);
    }

    private void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
        reader.moveDown();
        Object key = this.readItem(reader, context, map);
        reader.moveUp();
        reader.moveDown();
        Object value = this.readItem(reader, context, map);
        reader.moveUp();
        target.put(key, value);
    }

    public boolean canConvert(Class type) {
        return type.equals(HashMap.class) || type.equals(Hashtable.class) || type.getName().equals("java.util.LinkedHashMap") || type.getName().equals("java.util.concurrent.ConcurrentHashMap") || type.getName().equals("sun.font.AttributeMap");
    }
}

