package ch.sahits.game.openpatrician.model;

/**
 * Interface for balance data of the a week. The week must not necessairily be completed
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 20, 2012
 *
 */
public interface IBalanceSheet {
	/**
	 * Retrieve the rental income
	 * @return income from renting houses
	 */
	int getRentalIncome();
	/**
	 * Retrieve the wage costs
	 * @return costs for workshop wages
	 */
	int getWageCosts();
	/**
	 * Retrieve the property taxes
	 * @return costs of property taxes
	 */
	int getPropertyTaxes();
	/**
	 * Retrieve the balance for the office trading
	 * @return income/deficit from automatic office trading
	 */
	int getOfficeTrading();
	/**
	 * Retrieve the wages for the stewards
	 * @return wage costs of the steward
	 */
	int getStewardCost();
	/**
	 * Retrieve other unspecified costs like fines
	 * @return various other costs
	 */
	int getOtherCosts();

	/**
	 * Update the stewards costs.
	 * @param costPerDay salary per day
	 */
	void updateStewardCosts(int costPerDay);

	/**
	 * Update the rental income.
	 * @param incomePerDay daily rental income
	 */
	void updateRentalIncome(int incomePerDay);

	/**
	 * Subtract the property taxes.
	 * @param amount tax amount
	 */
	void deductPropertyTaxes(int amount);

	/**
	 * Update the salaries for workers in the workshop
	 * @param saleriesPerDay total salary of all workers per day
	 */
	void updateSalaries(int saleriesPerDay);

	/**
	 * Update the costs for automated trading
	 * @param costsPerDay incured costs per day
	 */
	void updateAutomatedTradingCosts(long costsPerDay);

	/**
	 * Update various other expenses.
	 * @param costsPerDay cost per day.
	 */
	void updateOtherExpensesRegular(int costsPerDay);

	/**
	 * Update other expences that do not occur regularly.
	 * @param costs one time costs.
	 */
	void updateOtherExpensesOneTime(int costs);
}
