package ch.sahits.game.openpatrician.model;

/**
 * Message that is displayable in one form or another.
 * @author Andi Hotz, (c) Sahits GmbH, 2018
 * Created on Oct 21, 2018
 */
public interface IDisplayableMessage {

    /**
     * Text key for the displayable message, so that it can be translated.
     * @return message key
     */
    String getMessageKey();

    /**
     * Array of arguments that go into the replaced message.
     * @return array of objects.
     */
    Object[] getMessageArguments();
}
