package ch.sahits.game.openpatrician.model.building;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;


/**
 * Basic definition of a building.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 17, 2011
 *
 */
public interface IBuilding {
	/**
	 * Retrieve the owner of the trading office
	 * @return owner of the building
	 */
	IPlayer getOwner();

	/**
	 * Some buildings may be sold to other players.
	 * @param newOwner owner of the building
	 */
	void setOwner(IPlayer newOwner);
	/**
	 * Retrieve the amount of property taxes per week
	 * @return property tax of the building per week.
	 */
	int getPropertyTax();
	/**
	 * Retrieve the value of the building
	 * @return value of the building
	 */
	int getValue();

	/**
	 * Execute when the building is destroyed.
	 */
	void destroy();

	/**
	 * Retreive the location of the building.
	 * @return city in which the building stands.
	 */
	ICity getCity();
}
