package ch.sahits.game.openpatrician.model.building;

import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.IntegerProperty;

/**
 * Additional over all ware houses connected to a trading office 
 * @author Andi Hotz, (c) Sahits GmbH, 2012
 * Created on Jul 25, 2012
 *
 */
public interface IStorage {
	/**
	 * Retrieve the amount of storage in barrels that is rented by someone else
	 * @return integer property for rented out storage
	 */
	IntegerProperty rentOutStorageProperty();
	/**
	 * Update the rented out space
	 * @param nbBarrels rented out space in barrels
	 */
	void updateRendedSpace(int nbBarrels);
	/**
	 * Retrieve the daily cost for rent storage
	 * @return integer binding of daily costs for renting additional space.
	 */
	IntegerBinding costsPerDayBinding();
	/**
	 * Retrieve the number of guards
	 * @return IntegerProperty for number of guards.
	 */
	IntegerProperty numberGuardsProperty();
	/**
	 * Retrieve the costs for the guards
	 * @return IntegerBinding for guard salary per day.
	 */
	IntegerBinding guardCostsPerDayBinding();
	/**
	 * Retrieve the security level
	 * @return object binding of security level
	 */
	ObjectBinding<ELevel> securityLevelBinding();
	/**
	 * Increase or decrease the number of guards
	 * @param update delta in the number of guards.
	 */
	void updateGuardsNumber(int update);

}
