package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.ICitizen;

import java.time.LocalDateTime;

/**
 * Request for a loan.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
public interface ILoanRequest {
    /**
     * Retrieve the date when the request was issued. This date is always in the past.
      * @return date when the request has been issued.
     */
    LocalDateTime issued();

    /**
     * Who wants the loan.
     * @return citizen who issued the request
     */
    ICitizen getCitizen();

    /**
     * Retrieve the duration of the loan.
     * @return duration of the loan request in weeks
     */
    int getDurationInWeeks();

    /**
     * Amount to be loaned.
     * @return amount to be loaned.
     */
    int getSum();
}
