package ch.sahits.game.openpatrician.model.city;

import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanRequest;

import java.util.List;

/**
 * Representing the loaner in a city. The loaner gets weekly updates
 * with new loan requests from citizens. He also holds the list of all
 * depts.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 30, 2014
 */
public interface ILoaner {
    /**
     * Retrieve the list of all debts for this city.
     * @return list of debts of the loaner
     */
    List<IDebt> getDebts();

    /**
     * Retrieve the loans that can be taken.
     * @return list of loan proposals of the loaner
     */
    List<ILoanProposal> getLoanProposals();

    /**
     * Add a new debt to the list.
     * @param debt to be added
     */
    void addDebt(IDebt debt);

    /**
     * List of requested loans.
     * @return list of loan requests of the loaner
     */
    List<ILoanRequest> getRequests();

    /**
     * Retrieve the city the loaner belongs to.
     * @return city where the loaner resides.
     */
    ICity getCity();

    /**
     * Remove request that are older than a certain time span.
     */
    void clearOldRequests();

    /**
     * Add a loan proposal.
     * @param proposal to be added
     */
    void add(LoanProposal proposal);

    /**
     * Add a loan request.
     * @param request to be added
     */
    void add(LoanRequest request);
}
