package ch.sahits.game.openpatrician.model.city.cityhall;

import ch.sahits.game.openpatrician.model.ship.IShip;

/**
 * Contract for an outrigger.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Mar 21, 2015
 */
public interface IOutriggerContract {
    /**
     * Get the outrigger ship.
     * @return ship that is the current outrigger.
     */
    IShip getOutrigger();

    /**
     * Retrieve the minimum weapons strength agreed upon.
     * @return minimal weapon strength standard.
     */
    int getMinWeaponsStrength();

    /**
     * Retrieve the amount that is payed weekly for the service.
     * @return weekly refund for the outrigger.
     */
    int getWeeklyRefund();
}
