package ch.sahits.game.openpatrician.model.city.cityhall.impl;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ECityViolationPunishment;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityViolation;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 31, 2014
 */
public abstract class CityViolation implements ICityViolation {
    @Getter
    private final ICity city;
    @Getter
    private final LocalDateTime date;
    @Getter
    @Setter
    private ECityViolationPunishment punishment;

    public CityViolation(ICity city, LocalDateTime date) {
        this.city = city;
        this.date = date;
    }
}
