package ch.sahits.game.openpatrician.model.city.guild;

import ch.sahits.game.openpatrician.model.IPlayer;
import javafx.geometry.Point2D;

import java.util.List;
import java.util.Map;

/**
 * Model for the mediterrean map with all the explored spots and discovered cities.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 06, 2016
 */
public interface IMediterreanMap {
    /**
     * Player explored a spot and may have detected a trading spot.
     * Trading spots can be detected in a certain radius of the explored spot.
     * @param player that does the exploring
     * @param coordinates location that is explored
     * @return true if a new trading spot was discovered.
     */
    boolean exploreSpot(IPlayer player, Point2D coordinates);

    /**
     * Retrieve a map of all discovered trading spot locations along with their
     * names.
     * @return map of coordinates and names of trading spots in the mediterrenian.
     */
    Map<Point2D, IMediterreanCity> getDiscoveredTradingSpots();

    /**
     * Retrieve a list of all discovered location for a player.
     * @param player for which the location should be retrieved.
     * @return list of all disovered locations.
     */
    List<Point2D> getExploredLocations(IPlayer player);

    /**
     * Add a trade agreement for a player.
     * @param player for whom to add an agreement
     * @param agreement to be added.
     */
    void addTradeAgreement(IPlayer player, ITradeAgreement agreement);

    /**
     * Retreive the trade agreements for a specific player.
     * @param player for which the agreement should be looked up.
     * @return list of trade agreements.
     */
    List<ITradeAgreement> getTradeAgreements(IPlayer player);
}
