package ch.sahits.game.openpatrician.model.city.guild.impl;

import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.EBidLevel;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.utilities.CancelableRunnable;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.annotation.OptionalType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

/**
 * This class implements the base fuctionality as defined by {@link IAuction}.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 13, 2016
 * @see IAuction
 */
@Prototype
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.MODEL, EClassCategory.SERIALIZABLE_BEAN})
public abstract class AbstractAuction implements IAuction {
    @Getter
    @Setter
    private LocalDateTime auctionDate;
    @Getter
    private final int startingBid;
    @Getter
    @OptionalType(IPlayer.class)
    private final Optional<IPlayer> owner;
    @Getter
    @Setter
    private EBidLevel bidLevel;
    @Getter
    @Setter
    private IPlayer biddingPlayer;
    @Getter
    @Setter
    private int currentBid;
    @Getter
    @Setter
    @ListType(IAIPlayer.class)
    private List<IAIPlayer> biddingPlayers;
    @Getter
    @Setter
    @XStreamOmitField // If an auction was running while saving it will be restarted on load
    private CancelableRunnable currentTask;

    /**
     * Construct an auction object without an owner.
     * @param auctionDate date of the auction
     * @param startingBid initial bid
     */
    public AbstractAuction(LocalDateTime auctionDate, int startingBid) {
        this.auctionDate = auctionDate;
        this.startingBid = startingBid;
        owner = Optional.empty();
    }

    /**
     * Create an auction object with a specific owner.
     * @param auctionDate date of the acution
     * @param startingBid initial bid
     * @param owner owner of the auctioned item
     */
    public AbstractAuction(LocalDateTime auctionDate, int startingBid, IPlayer owner) {
        this.auctionDate = auctionDate;
        this.startingBid = startingBid;
        this.owner = Optional.of(owner);
    }
}
