package ch.sahits.game.openpatrician.model.city.impl;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.collect.Lists;
import lombok.Getter;

import java.util.List;

/**
 * Container for all the cities.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jul 16, 2015
 */
@LazySingleton
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class CityRegistry {
    @Getter
    @ListType(CityState.class)
    private List<CityState> cityStates = Lists.newArrayList();

    public boolean add(CityState cityState) {
        return cityStates.add(cityState);
    }


}
