package ch.sahits.game.openpatrician.model.event;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import lombok.Getter;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Apr 28, 2016
 */
@ClassCategory(EClassCategory.EVENT_OBJECT)
@Getter
public class FoundingCityBecomesAccessible implements IEventMetaDataProvider {
    private final ICity city;
    private String className;
    private String methodName;

    public FoundingCityBecomesAccessible(ICity city) {
        this.city = city;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        methodName = creatingStackFrame.getMethodName();
        className = creatingStackFrame.getClassName();
    }
}
